/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.angel.challenges6t4.challenge.Challenge;

public class ChallengeRegistry {
    private static final Map<String, Challenge> CHALLENGES = new HashMap<String, Challenge>();

    public static void register(Challenge challenge) {
        CHALLENGES.put(challenge.getId(), challenge);
    }

    public static Challenge getChallenge(String id) {
        return CHALLENGES.get(id);
    }

    public static Collection<Challenge> getAllChallenges() {
        return CHALLENGES.values();
    }

    public static boolean isAnyEnabled() {
        return CHALLENGES.values().stream().anyMatch(Challenge::isEnabled);
    }

    public static boolean areAllBeatable() {
        return CHALLENGES.values().stream().filter(Challenge::isEnabled).allMatch(challenge -> !challenge.isTrueMode() && challenge.isGameBeatable());
    }

    public static void clear() {
        CHALLENGES.clear();
    }
}

